import defaultTheme from "tailwindcss/defaultTheme";
import forms from "@tailwindcss/forms";

/** @type {import('tailwindcss').Config} */
export default {
    darkMode: "class",
    content: [
        "./vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php",
        "./storage/framework/views/*.php",
        "./resources/views/**/*.blade.php",
        "./app/Livewire/**/*Table.php",
        "./vendor/power-components/livewire-powergrid/resources/views/**/*.php",
        "./vendor/power-components/livewire-powergrid/src/Themes/Tailwind.php",
    ],
    presets: [
        require("./vendor/power-components/livewire-powergrid/tailwind.config.js"),
    ],
    theme: {
        extend: {
            screens: {
                xs: { max: "360px" },
                xss: { min: "400px" }, // Custom media query for 360px
            },
            fontFamily: {
                sans: ["Inter", ...defaultTheme.fontFamily.sans],
                display: ["Lexend", ...defaultTheme.fontFamily.sans],
            },
            animation: {
                "bounce-slow-subtle": "bounce-subtle 7s infinite ease-in-out",
                "infinite-scroll": "infinite-scroll 25s linear infinite",
                "spin-slow": "spin 15s linear infinite",
                "pulse-slow": "pulse 3s cubic-bezier(0.4, 0, 0.6, 1) infinite",
                "clock-hour-hand": "clockHourHand 12s linear infinite",
                "clock-minute-hand": "clockMinuteHand 60s linear infinite",
            },
            bounce: {
                "0%, 100%": {
                    transform: "translateY(-10%)",
                    animationTimingFunction: "ease-in-out",
                },
                "50%": {
                    transform: "translateY(0)",
                    animationTimingFunction: "ease-in-out",
                },
            },
            keyframes: {
                "infinite-scroll": {
                    from: { transform: "translateX(0)" },
                    to: { transform: "translateX(-100%)" },
                },
                clockHourHand: {
                    "0%": { transform: "rotate(0deg)" },
                    "100%": { transform: "rotate(360deg)" },
                },
                clockMinuteHand: {
                    "0%": { transform: "rotate(0deg)" },
                    "100%": { transform: "rotate(360deg)" },
                },
                "bounce-subtle": {
                    "0%, 100%": { transform: "translateY(0)" },
                    "50%": { transform: "translateY(-20px)" }, // only move up a little
                },
            },
        },
    },
    plugins: [
        require("@tailwindcss/forms"),
        require("@tailwindcss/typography"),
        require("@tailwindcss/aspect-ratio"),
    ],

    plugins: [forms],
};
