<x-app-layout>
<div class="bg-white shadow-sm rounded-lg p-6">
    <div class="flex justify-between items-start mb-6">
        <div>
            <h1 class="text-2xl font-bold">{{ $plan->name }}</h1>
            <p class="text-gray-600 mt-1">{{ $plan->description }}</p>
        </div>
        <div class="text-right">
            <div class="text-3xl font-bold">{{ $plan->formatted_price }}</div>
        </div>
    </div>

    <!-- Plan Features -->
    @if(!empty($plan->features))
        <div class="mt-6">
            <h2 class="text-lg font-semibold mb-3">{{ t('features') }}</h2>
            <ul class="space-y-2">
                @foreach($plan->features as $feature)
                    <li class="flex items-start">
                        <svg class="h-5 w-5 text-green-500 mr-2 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                        </svg>
                        <span>{{ $feature }}</span>
                    </li>
                @endforeach
            </ul>
        </div>
    @endif

    <!-- Trial Info -->
    @if($plan->trial_period)
        <div class="mt-6 bg-blue-50 p-4 rounded-md border border-blue-100">
            <div class="flex">
                <svg class="h-6 w-6 text-blue-500 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <div>
                    <h3 class="font-medium text-blue-800">{{ $plan->trial_period }}{{ t('day_free_trial') }}</h3>
                    <p class="text-blue-700 text-sm mt-1">{{ t('start_with_free_trial') }}</p>
                </div>
            </div>
        </div>
    @endif

    <!-- Subscription Button -->
    <div class="mt-8 flex justify-center">
        @auth
            <a href="{{ route('checkout', ['plan' => $plan->uid]) }}" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                @if($plan->trial_period)
                    {{ t('start_free_trial') }}
                @else
                       {{ t('subscribe_now') }}
                @endif
            </a>
        @else
            <div class="text-center">
                <p class="mb-4 text-gray-600">{{ t('login_to_subscribe_plan') }}</p>
                <a href="{{ route('login') }}" class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                    {{ t('login') }}
                </a>
                <a href="{{ route('register') }}" class="ml-3 inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                    {{ t('register') }}
                </a>
            </div>
        @endauth
    </div>

    <!-- Back Link -->
    <div class="mt-8 text-center">
        <a href="{{ tenant_route('tenant.subscription') }}" class="text-blue-600 hover:underline">
            {{ t('back_to_plans') }}
        </a>
    </div>
</div>
</x-app-layout>
