<div >
    <x-slot:title>
        {{ t('system_core_settings') }}
    </x-slot:title>

    <!-- Page Heading -->
    <div class="pb-6">
        <x-settings-heading>{{ t('system_settings') }}</x-settings-heading>
    </div>

    <div class="flex flex-wrap lg:flex-nowrap gap-4">
        <!-- Sidebar Menu -->
        <div class="w-full lg:w-1/5">
            <x-tenant-system-settings-navigation wire:ignore />
        </div>

        <div class="flex-1 space-y-5">
            <form wire:submit="save" class="space-y-6" x-data x-init="window.initTomSelect('.tom-select')">
                <x-card class="rounded-lg">
                    <x-slot:header>
                        <x-settings-heading>{{ t('system_core_settings') }}</x-settings-heading>
                        <x-settings-description>
                            {{ t('system_core_settings_description') }}
                        </x-settings-description>
                    </x-slot:header>

                    <x-slot:content>
                        <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">
                            <div class="sm:col-span-3 lg:col-span-1">
                                <x-label for="site_name" :value="t('site_name')" />
                                <x-input wire:model.defer="site_name" type="text" id="site_name"
                                    class="mt-1 block w-full" />
                                <x-input-error for="site_name" class="mt-2" />
                            </div>

                            <div class="sm:col-span-3 lg:col-span-2">
                                <x-label for="site_description" :value="t('site_description')" />
                                <x-input wire:model.defer="site_description" id="site_description"
                                    class="mt-1 block w-full" />
                                <x-input-error for="site_description" class="mt-2" />
                            </div>
                        </div>

                        <h3 class="text-lg font-medium text-gray-900 mb-2 mt-4 dark:text-slate-300">
                            {{ t('localization') }}
                        </h3>

                        <div class="grid grid-cols-1 gap-4 sm:grid-cols-4 z-0">
                            <div wire:ignore>
                                <x-label for="timezone" :value="t('timezone')" />
                                <x-select id="timezone" class="mt-1 block w-full tom-select"
                                    wire:model.defer="timezone" wire:change="$set('timezone', $event.target.value)">
                                    <option>{{ t('select_timezone') }}</option>
                                    @foreach ($timezone_list as $tz)
                                        <option value="{{ $tz }}" {{ $tz == $timezone ? 'selected' : '' }}>
                                            {{ $tz }}
                                        </option>
                                    @endforeach
                                </x-select>
                                <x-input-error for="timezone" class="mt-2" />
                            </div>

                            <div wire:ignore>
                                <x-label for="date_format" :value="t('date_format')" />
                                <x-select id="date_format" class="mt-1 block w-full tom-select"
                                    wire:model.defer="date_format"
                                    wire:change="$set('date_format', $event.target.value)">
                                    <option>{{ t('select_date_format') }}</option>
                                    @foreach ($date_formats as $format => $example)
                                        <option value="{{ $format }}"
                                            {{ $format == $date_format ? 'selected' : '' }}>
                                            {{ $example }}
                                        </option>
                                    @endforeach
                                </x-select>
                                <x-input-error for="date_format" class="mt-2" />
                            </div>

                            <div wire:ignore>
                                <x-label for="time_format" :value="t('time_format')" />
                                <x-select id="time_format" class="mt-1 block w-full tom-select"
                                    wire:model.defer="time_format"
                                    wire:change="$set('time_format', $event.target.value)">
                                    <option>{{ t('select_time_format') }}</option>
                                    <option value="24" {{ $time_format == '24' ? 'selected' : '' }}>
                                        {{ t('24_hours') }}
                                    </option>
                                    <option value="12" {{ $time_format == '12' ? 'selected' : '' }}>
                                        {{ t('12_hours') }}
                                    </option>
                                </x-select>
                                <x-input-error for="time_format" class="mt-2" />
                            </div>

                            <div wire:ignore>
                                <x-label for="active_language" :value="t('default_language')" />
                                <x-select id="active_language" class="mt-1 block w-full tom-select"
                                    wire:model.defer="active_language"
                                    wire:change="$set('active_language', $event.target.value)">
                                    <option>{{ t('select_language') }}</option>
                                    @foreach (getLanguage(null, ['code', 'name']) as $language)
                                        <option value="{{ $language->code }}"
                                            {{ $language->code == $active_language ? 'selected' : '' }}>
                                            {{ $language->name }}
                                        </option>
                                    @endforeach
                                </x-select>
                                <x-input-error for="active_language" class="mt-2" />
                            </div>
                        </div>

                        <h3 class="text-lg font-medium text-gray-900 mb-2 mt-4 dark:text-slate-300">
                            {{ t('logo_favicon') }} </h3>
                        <!-- Company Logo Upload -->
                        <div x-data="{
                            photoPreview: null,
                            init() {
                                if ('{{ $current_company_light_logo }}') {
                                    this.photoPreview = '{{ asset('storage/' . $current_company_light_logo) }}';
                                }
                            },
                            photoName: null,
                            photoPreview: null,
                            maxSizeMB: 5,
                            allowedTypes: ['jpeg', 'png', 'jpg', 'svg'],
                            errorMessage: '',
                            validateFile(input) {
                                this.errorMessage = '';
                                let file = input.files[0];
                                if (!file) return;

                                let fileExtension = file.name.split('.').pop().toLowerCase();
                                if (!this.allowedTypes.includes(fileExtension)) {
                                    this.errorMessage = `Invalid file type. Allowed: ${this.allowedTypes.join(', ')}`;
                                    input.value = '';
                                    return;
                                }

                                const maxSizeBytes = this.maxSizeMB * 1024 * 1024;
                                if (file.size > maxSizeBytes) {
                                    this.errorMessage = `File size exceeds ${this.maxSizeMB}MB limit`;
                                    input.value = '';
                                    return;
                                }

                                this.photoName = file.name;
                                const reader = new FileReader();
                                reader.onload = (e) => this.photoPreview = e.target.result;
                                reader.readAsDataURL(file);
                            }
                        }">
                            <x-label for="company_light_logo" :value="new \Illuminate\Support\HtmlString(
                                t('company_light_logo') .
                                    '<em class=\'text-indigo-600\'> (' .
                                    t('recommended') .
                                    ' 22px x 40px)</em>',
                            )" class="mb-2" />

                            <div class="relative p-6 border-2 border-dashed rounded-lg cursor-pointer hover:border-blue-500 transition duration-300"
                                x-on:click="$refs.logo.click()">
                                <div class="flex items-center justify-center">
                                    <template x-if="photoPreview">
                                        <img :src="photoPreview" alt="Logo Preview"
                                            class="h-24 w-48 object-contain rounded-lg shadow-md">
                                    </template>
                                    <template x-if="!photoPreview">
                                        <div class="text-center">
                                            <svg class="h-12 w-12 text-gray-400 mx-auto" fill="none"
                                                stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                            </svg>
                                            <p class="mt-2 text-sm text-gray-600">
                                                {{ t('select_or_browse_to') }} <span
                                                    class="text-indigo-600 underline">{{ t('company_logo') }}</span>
                                            </p>
                                        </div>
                                    </template>
                                </div>
                                <input type="file" class="hidden" wire:model="temp_company_light_logo" x-ref="logo"
                                    accept="image/png,image/jpeg,image/jpg,image/svg"
                                    x-on:change="validateFile($event.target)">
                            </div>

                            <div x-show="errorMessage" class="text-red-500 text-sm mt-2" x-text="errorMessage"></div>
                            @if ($current_company_light_logo)
                                <x-button.text type="button" wire:click="removeImage('company_light_logo')"
                                    class="mt-2 text-red-500 hover:text-red-600">
                                    {{ t('remove') }}
                                </x-button.text>
                            @endif
                            <x-input-error for="temp_company_light_logo" class="mt-2" />
                        </div>

                        <div x-data="{
                            photoPreview: null,
                            init() {
                                if ('{{ $current_company_dark_logo }}') {
                                    this.photoPreview = '{{ asset('storage/' . $current_company_dark_logo) }}';
                                }
                            },
                            photoName: null,
                            photoPreview: null,
                            maxSizeMB: 5,
                            allowedTypes: ['jpeg', 'png', 'jpg', 'svg'],
                            errorMessage: '',
                            validateFile(input) {
                                this.errorMessage = '';
                                let file = input.files[0];
                                if (!file) return;

                                let fileExtension = file.name.split('.').pop().toLowerCase();
                                if (!this.allowedTypes.includes(fileExtension)) {
                                    this.errorMessage = `Invalid file type. Allowed: ${this.allowedTypes.join(', ')}`;
                                    input.value = '';
                                    return;
                                }

                                const maxSizeBytes = this.maxSizeMB * 1024 * 1024;
                                if (file.size > maxSizeBytes) {
                                    this.errorMessage = `File size exceeds ${this.maxSizeMB}MB limit`;
                                    input.value = '';
                                    return;
                                }

                                this.photoName = file.name;
                                const reader = new FileReader();
                                reader.onload = (e) => this.photoPreview = e.target.result;
                                reader.readAsDataURL(file);
                            }
                        }">
                            <x-label for="company_dark_logo" :value="new \Illuminate\Support\HtmlString(
                                t('company_dark_logo') .
                                    '<em class=\'text-indigo-600\'> (' .
                                    t('recommended') .
                                    ' 22px x 40px)</em>',
                            )" class="mb-2 mt-4" />

                            <div class="relative p-6 border-2 border-dashed rounded-lg cursor-pointer hover:border-blue-500 transition duration-300"
                                x-on:click="$refs.logo.click()">
                                <div class="flex items-center justify-center">
                                    <template x-if="photoPreview">
                                        <img :src="photoPreview" alt="Logo Preview"
                                            class="h-24 w-48 object-contain rounded-lg shadow-md">
                                    </template>
                                    <template x-if="!photoPreview">
                                        <div class="text-center">
                                            <svg class="h-12 w-12 text-gray-400 mx-auto" fill="none"
                                                stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                            </svg>
                                            <p class="mt-2 text-sm text-gray-600">
                                                {{ t('select_or_browse_to') }} <span
                                                    class="text-indigo-600 underline">{{ t('company_dark_logo') }}</span>
                                            </p>
                                        </div>
                                    </template>
                                </div>
                                <input type="file" class="hidden" wire:model="temp_company_dark_logo" x-ref="logo"
                                    accept="image/png,image/jpeg,image/jpg,image/svg"
                                    x-on:change="validateFile($event.target)">
                            </div>

                            <div x-show="errorMessage" class="text-red-500 text-sm mt-2" x-text="errorMessage"></div>
                            @if ($current_company_dark_logo)
                                <x-button.text type="button" wire:click="removeImage('company_dark_logo')"
                                    class="mt-2 text-red-500 hover:text-red-600">
                                    {{ t('remove') }}
                                </x-button.text>
                            @endif
                            <x-input-error for="temp_company_dark_logo" class="mt-2" />
                        </div>

                        <!-- Favicon Upload -->
                        <div x-data="{
                            photoPreview: null,
                            init() {
                                if ('{{ $current_favicon }}') {
                                    this.photoPreview = '{{ asset('storage/' . $current_favicon) }}';
                                }
                            },
                            photoName: null,
                            photoPreview: null,
                            maxSizeMB: 5,
                            allowedTypes: ['jpeg', 'png', 'jpg', 'svg'],
                            errorMessage: '',
                            validateFile(input) {
                                this.errorMessage = '';
                                let file = input.files[0];
                                if (!file) return;

                                let fileExtension = file.name.split('.').pop().toLowerCase();
                                if (!this.allowedTypes.includes(fileExtension)) {
                                    this.errorMessage = `Invalid file type. Allowed: ${this.allowedTypes.join(', ')}`;
                                    input.value = '';
                                    return;
                                }

                                const maxSizeBytes = this.maxSizeMB * 1024 * 1024;
                                if (file.size > maxSizeBytes) {
                                    this.errorMessage = `File size exceeds ${this.maxSizeMB}MB limit`;
                                    input.value = '';
                                    return;
                                }

                                this.photoName = file.name;
                                const reader = new FileReader();
                                reader.onload = (e) => this.photoPreview = e.target.result;
                                reader.readAsDataURL(file);
                            }
                        }">
                            <x-label for="favicon" :value="new \Illuminate\Support\HtmlString(
                                t('favicon') .
                                    '<em class=\'text-indigo-600\'> (' .
                                    t('recommended') .
                                    ' 32px x 32px)</em>',
                            )" class="mb-2 mt-4" />

                            <div class="relative p-6 border-2 border-dashed rounded-lg cursor-pointer hover:border-blue-500 transition duration-300"
                                x-on:click="$refs.favicon.click()">
                                <div class="flex items-center justify-center">
                                    <template x-if="photoPreview">
                                        <img :src="photoPreview" alt="Favicon Preview"
                                            class="h-24 w-24 object-contain rounded-lg shadow-md">
                                    </template>
                                    <template x-if="!photoPreview">
                                        <div class="text-center">
                                            <svg class="h-12 w-12 text-gray-400 mx-auto" fill="none"
                                                stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                            </svg>
                                            <p class="mt-2 text-sm text-gray-600">
                                                {{ t('select_or_browse_to') }} <span
                                                    class="text-indigo-600 underline">{{ t('favicon') }}</span>
                                            </p>
                                        </div>
                                    </template>
                                </div>
                                <input type="file" class="hidden" wire:model="temp_favicon" x-ref="favicon"
                                    accept="image/png,image/jpeg,image/jpg,image/svg"
                                    x-on:change="validateFile($event.target)">
                            </div>

                            <div x-show="errorMessage" class="text-red-500 text-sm mt-2" x-text="errorMessage"></div>
                            @if ($current_favicon)
                                <x-button.text type="button" wire:click="removeImage('favicon')"
                                    class="mt-2 text-red-500 hover:text-red-600">
                                    {{ t('remove') }}
                                </x-button.text>
                            @endif
                            <x-input-error for="temp_favicon" class="mt-2" />
                        </div>
                    </x-slot:content>
                    @if (checkPermission('tenant.system_settings.edit'))
                        <x-slot:footer class="bg-slate-50 dark:bg-transparent rounded-b-lg">
                            <div class="flex justify-end">
                                <x-button.loading-button type="submit" target="save">
                                    {{ t('save_changes') }}
                                </x-button.loading-button>
                            </div>
                        </x-slot:footer>
                    @endif
                </x-card>
            </form>
        </div>
    </div>
</div>
