<div style="color-scheme: dark;">
    @php
        $user = auth()->user();
        $systemSettings = tenant_settings_by_group('system');
        $settings = get_batch_settings(['theme.favicon']);
        $favicon = $settings['theme.favicon'];
    @endphp

    {{-- SIDEBAR FOR ADMIN --}}
    <!-- Off-canvas menu for mobile, show/hide based on off-canvas menu state. -->
    <div x-cloak x-show="open" class="relative z-40 lg:hidden" role="dialog" aria-modal="true" x-data="{ mobileOpen: false }">
        <div x-show="open" x-transition:enter="transition-opacity ease-linear duration-300"
            x-transition:enter-start="opacity-0" x-transition:enter-end="opacity-100"
            x-transition:leave="transition-opacity ease-linear duration-300" x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0" x-on:click="open = false"
            class="fixed inset-0 bg-slate-600 bg-opacity-75"></div>

        <div class="fixed inset-0 flex z-40">
            <!-- Mobile Menu (Overlapping Open Menu) -->
            <div x-show="mobileOpen"
                class="absolute top-0 left-0 z-50 lg:hidden sm:w-80 w-60  h-full bg-white dark:bg-slate-800 shadow-lg"
                x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 transform -translate-x-full"
                x-transition:enter-end="opacity-100 transform translate-x-0"
                x-transition:leave="transition ease-in duration-300"
                x-transition:leave-start="opacity-100 transform translate-x-0"
                x-transition:leave-end="opacity-0 transform -translate-x-full" x-init="mobileOpen = {{ json_encode(
                    request()->routeIs(
                        'tenant.staff.*',
                        'tenant.roles.*',
                        'tenant.status',
                        'tenant.source',
                        'tenant.ai-prompt',
                        'tenant.canned-reply',
                        'tenant.activity-log.*',
                        'tenant.languages',
                        'tenant.emails',
                        'tenant.logs.index',
                    ),
                ) }}">

                <!-- Close Button -->
                <div class="flex justify-between items-center py-4 flex-shrink-0 px-5 bg-white dark:bg-slate-800">
                    <span class="text-lg font-semibold text-gray-600 dark:text-slate-300"> {{ t('setup') }}
                    </span>
                    <!-- Close Button -->
                    <button x-on:click.stop="mobileOpen = false" class="text-gray-500 dark:text-slate-400">
                        <x-heroicon-o-x-mark class="w-5 h-5" />
                    </button>
                </div>

                <div class="flex-1 flex flex-col overflow-y-auto">
                    <nav class="flex-1 px-2">
                        <!-- Staff -->
                        @if (request()->routeIs('tenant.*'))
                            @if (checkPermission('tenant.staff.view'))
                                @hasFeature('staff')
                                    <a href="{{ tenant_route('tenant.staff.list') }}"
                                        class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                    {{ request()->routeIs('tenant.staff.list')
                                        ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                        : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                        <x-heroicon-o-users
                                            class="mr-4 flex-shrink-0 h-6 w-6
                                        {{ request()->routeIs('tenant.staff.list')
                                            ? 'text-indigo-600 dark:text-slate-300'
                                            : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                            aria-hidden="true" />
                                        {{ t('staff') }}
                                    </a>
                                @endhasFeature
                            @endif

                            <!-- Role -->
                            @if (checkPermission('tenant.role.view') && Auth::user()->is_admin && Auth::user()->user_type === 'tenant')
                                <a href="{{ tenant_route('tenant.roles.list') }}"
                                    class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                               {{ request()->routeIs('tenant.roles.list')
                                   ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                   : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                    <x-heroicon-o-swatch
                                        class="mr-4 flex-shrink-0 h-6 w-6
                                   {{ request()->routeIs('tenant.roles.list')
                                       ? 'text-indigo-600 dark:text-slate-300'
                                       : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                        aria-hidden="true" />
                                    {{ t('role') }}
                                </a>
                            @endif

                            @if (checkPermission('tenant.status.view'))
                                <a href="{{ tenant_route('tenant.status') }}"
                                    class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                               {{ request()->routeIs('tenant.status')
                                   ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                   : 'text-gray-600 hover:bg-indigo-50 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                    <x-heroicon-c-adjustments-horizontal
                                        class="mr-4 flex-shrink-0 h-6 w-6
                               {{ request()->routeIs('tenant.status')
                                   ? 'text-indigo-600 dark:text-slate-300'
                                   : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}" />
                                    {{ t('status') }}
                                </a>
                            @endif

                            @if (checkPermission('tenant.source.view'))
                                <a href="{{ tenant_route('tenant.source') }}"
                                    class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                           {{ request()->routeIs('tenant.source')
                               ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                               : 'text-gray-600 hover:bg-indigo-50 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                    <x-heroicon-o-square-3-stack-3d
                                        class="mr-4 flex-shrink-0 h-6 w-6
                           {{ request()->routeIs('tenant.source')
                               ? 'text-indigo-600 dark:text-slate-300'
                               : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}" />
                                    {{ t('source') }}
                                </a>
                            @endif

                            <!-- AI Prompts -->
                            @if (checkPermission('tenant.ai_prompt.view'))
                                @hasFeature('ai_prompts')
                                    <a href="{{ tenant_route('tenant.ai-prompt') }}"
                                        class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                           {{ request()->routeIs('tenant.ai-prompt')
                               ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                               : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                        <x-heroicon-o-rocket-launch
                                            class="mr-4 flex-shrink-0 h-6 w-6
                           {{ request()->routeIs('tenant.ai-prompt')
                               ? 'text-indigo-600 dark:text-slate-300'
                               : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                            aria-hidden="true" />
                                        {{ t('ai_prompts') }}
                                    </a>
                                @endhasFeature
                            @endif

                            <!-- Canned Reply -->
                            @if (checkPermission('tenant.canned_reply.view'))
                                @hasFeature('canned_replies')
                                    <a href="{{ tenant_route('tenant.canned-reply') }}"
                                        class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                           {{ request()->routeIs('tenant.canned-reply')
                               ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                               : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                        <x-heroicon-m-arrow-right-on-rectangle
                                            class="mr-4 flex-shrink-0 h-6 w-6
                           {{ request()->routeIs('tenant.canned-reply')
                               ? 'text-indigo-600 dark:text-slate-300'
                               : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                            aria-hidden="true" />
                                        {{ t('canned_reply') }}
                                    </a>
                                @endhasFeature
                            @endif

                            <!-- Activity Log -->
                            @if (checkPermission('tenant.activity_log.view'))
                                <a href="{{ tenant_route('tenant.activity-log.list') }}"
                                    class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                           {{ request()->routeIs('tenant.activity-log.list')
                               ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                               : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                    <x-heroicon-s-arrow-path
                                        class="mr-4 flex-shrink-0 h-6 w-6
                               {{ request()->routeIs('tenant.activity-log.list')
                                   ? 'text-indigo-600 dark:text-slate-300'
                                   : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                        aria-hidden="true" />
                                    {{ t('activity_log') }}
                                </a>
                            @endif


                            <!-- Language for desktop -->
                            @if (Auth::user()->is_admin && Auth::user()->user_type === 'tenant')
                                <a href="{{ tenant_route('tenant.languages') }}" @class([
                                    'group flex items-center px-4 py-2 text-sm font-medium rounded-r-md',
                                    request()->routeIs('tenant.languages')
                                        ? 'border-l-4 border-indigo-600 bg-indigo-50 dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                        : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white',
                                ])>
                                    <x-heroicon-s-language @class([
                                        'mr-4 flex-shrink-0 h-6 w-6',
                                        request()->routeIs('tenant.languages')
                                            ? 'text-indigo-600 dark:text-slate-300'
                                            : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300',
                                    ]) aria-hidden="true" />
                                    {{ t('languages') }}
                                </a>
                            @endif

                            <!-- Email Templates -->
                            @if (checkPermission('tenant.email_template.view'))
                                <a href="{{ tenant_route('tenant.emails') }}" @class([
                                    'group flex items-center px-4 py-2 text-sm font-medium rounded-r-md',
                                    request()->routeIs('tenant.emails')
                                        ? 'border-l-4 border-indigo-600 bg-indigo-50 dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                        : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white',
                                ])>
                                    <x-heroicon-o-envelope @class([
                                        'mr-4 flex-shrink-0 h-6 w-6',
                                        request()->routeIs('tenant.emails')
                                            ? 'text-indigo-600 dark:text-slate-300'
                                            : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300',
                                    ]) aria-hidden="true" />
                                    {{ t('email_template_list_title') }}
                                </a>
                            @endif

                            {{-- System Logs --}}

                            @if (module_exists('LogViewer') && module_enabled('LogViewer'))
                                <a href="{{ tenant_route('tenant.logs.index') }}" @class([
                                    'group flex items-center px-4 py-2 text-sm font-medium rounded-r-md',
                                    request()->routeIs('tenant.logs.index')
                                        ? 'border-l-4 border-indigo-600 bg-indigo-50 dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                        : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white',
                                ])>
                                    <x-heroicon-o-document-chart-bar @class([
                                        'mr-4 flex-shrink-0 h-6 w-6',
                                        request()->routeIs('tenant.logs.index')
                                            ? 'text-indigo-600 dark:text-slate-300'
                                            : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300',
                                    ]) aria-hidden="true" />
                                    {{ t('system_logs') }}
                                </a>
                            @endif
                        @endif
                    </nav>
                </div>
            </div>

            <div x-show="open" x-transition:enter="transition ease-in-out duration-300 transform"
                x-transition:enter-start="-translate-x-full" x-transition:enter-end="translate-x-0"
                x-transition:leave="transition ease-in-out duration-300 transform"
                x-transition:leave-start="translate-x-0" x-transition:leave-end="-translate-x-full"
                x-on:click.away="open = false" class="relative flex flex-col pt-5 bg-white dark:bg-slate-800">
                <div x-show="open" x-transition:enter="ease-in-out duration-300" x-transition:enter-start="opacity-0"
                    x-transition:enter-end="opacity-100" x-transition:leave="ease-in-out duration-300"
                    x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
                    class="absolute top-0 right-0 -mr-12 pt-2">
                </div>

                <div class="flex-shrink-0 flex items-center justify-center w-full ">
                    <a href="#" class="flex items-center bg-white dark:bg-slate-800">
                        <img x-bind:src="theme === 'light' || (theme === 'system' && window.matchMedia(
                                    '(prefers-color-scheme: light)')
                                .matches) ?
                            '{{ !empty($systemSettings['company_light_logo']) ? Storage::url($systemSettings['company_light_logo']) : url('./img/light_logo.png') }}' :
                            '{{ !empty($systemSettings['company_dark_logo']) ? Storage::url($systemSettings['company_dark_logo']) : url('./img/dark_logo.png') }}'"
                            alt="#" class="md:h-12 h-8 sm:h-12 px-4 w-auto object-cover" x-cloak>
                    </a>
                </div>
                <div class="mt-5 flex-1 h-0 overflow-y-auto">
                    <nav class=" px-2 py-4">
                        {{-- Sidebar for admin : Start --}}
                        @if (request()->routeIs('tenant.*'))
                            <a href="{{ tenant_route('tenant.dashboard') }}"
                                class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                            {{ request()->routeIs('tenant.dashboard')
                                ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                <x-heroicon-o-squares-2x2
                                    class="mr-4 flex-shrink-0 h-6 w-6
                            {{ request()->routeIs('tenant.dashboard')
                                ? 'text-indigo-600 dark:text-slate-300'
                                : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                    aria-hidden="true" />
                                {{ t('dashboard') }}
                            </a>

                            @if (checkPermission('tenant.connect_account.view'))
                                <a href="{{ tenant_route('tenant.connect') }}"
                                    class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                            {{ request()->routeIs(['tenant.connect', 'tenant.waba'])
                                ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                    <x-heroicon-o-link
                                        class="mr-4 flex-shrink-0 h-6 w-6
                            {{ request()->routeIs(['tenant.connect', 'tenant.waba'])
                                ? 'text-indigo-600 dark:text-slate-300'
                                : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                        aria-hidden="true" />
                                    {{ t('connect_waba') }}
                                </a>
                            @endif

                            @if (checkPermission(['tenant.subscription.view', 'tenant.invoices.view']))
                                <p class="text-sm text-gray-500 dark:text-slate-400 font-meduim px-5 py-4">
                                    {{ t('sales') }}
                                </p>
                            @endif

                            @if (checkPermission('tenant.subscription.view'))
                                <a href="{{ tenant_route('tenant.subscriptions') }}"
                                    class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                            {{ request()->routeIs('tenant.subscriptions')
                                ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                    <x-heroicon-o-credit-card
                                        class="mr-4 flex-shrink-0 h-6 w-6
                            {{ request()->routeIs('tenant.subscriptions')
                                ? 'text-indigo-600 dark:text-slate-300'
                                : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                        aria-hidden="true" />
                                    {{ t('subscription') }}
                                </a>
                            @endif

                            @if (checkPermission('tenant.invoices.view'))
                                <a href="{{ tenant_route('tenant.invoices') }}"
                                    class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                                        {{ request()->routeIs('tenant.invoices')
                                                            ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                                            : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                    <x-heroicon-o-receipt-percent
                                        class="mr-4 flex-shrink-0 h-6 w-6
                                                        {{ request()->routeIs('tenant.invoices')
                                                            ? 'text-indigo-600 dark:text-slate-300'
                                                            : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                        aria-hidden="true" />
                                    {{ t('invoices') }}
                                </a>
                            @endif

                            @if (checkPermission(['tenant.contact.view', 'tenant.contact.view_own']))
                                <p class="text-sm text-gray-500 dark:text-slate-400 font-meduim px-5 py-4">
                                    {{ t('contact') }}
                                </p>
                                @hasFeature('contacts')
                                    <a href="{{ tenant_route('tenant.contacts.list') }}"
                                        class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                            {{ request()->routeIs('tenant.contacts.list')
                                                ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                                : 'text-gray-600 hover:bg-indigo-50 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                        <x-heroicon-o-user-circle
                                            class="mr-4 flex-shrink-0 h-6 w-6
                                            {{ request()->routeIs('tenant.contacts.list')
                                                ? 'text-indigo-700 dark:text-slate-300'
                                                : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}" />
                                        {{ t('contact') }}
                                    </a>
                                @endhasFeature
                            @endif

                            @if (checkPermission('tenant.template.view'))
                                <p class="text-sm text-gray-500 dark:text-slate-400 font-meduim px-5 py-4">
                                    {{ t('templates') }}
                                </p>
                                <a href="{{ tenant_route('tenant.template.list') }}"
                                    class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                            {{ request()->routeIs('tenant.template.list')
                                ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                    <x-heroicon-o-document
                                        class="mr-4 flex-shrink-0 h-6 w-6
                                {{ request()->routeIs('tenant.template.list')
                                    ? 'text-indigo-600 dark:text-slate-300'
                                    : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}" />
                                    {{ t('templates') }}
                                </a>
                            @endif

                            @if (checkPermission([
                                    'tenant.campaigns.view',
                                    'tenant.bulk_campaigns.send',
                                    'tenant.message_bot.view',
                                    'tenant.template_bot.view',
                                ]))
                                <p class="text-sm text-gray-500 dark:text-slate-400 font-meduim px-5 py-4">
                                    {{ t('marketing') }}
                                </p>
                            @endif

                            {{-- Campaigns List --}}
                            @if (checkPermission('tenant.campaigns.view'))
                                @hasFeature('campaigns')
                                    <a href="{{ tenant_route('tenant.campaigns.list') }}"
                                        class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                        {{ request()->routeIs('tenant.campaigns.list')
                                            ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                            : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                        <x-heroicon-o-megaphone
                                            class="mr-4 flex-shrink-0 h-6 w-6
                                            {{ request()->routeIs('tenant.campaigns.list')
                                                ? 'text-indigo-600 dark:text-slate-300'
                                                : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                            aria-hidden="true" />
                                        {{ t('campaign') }}
                                    </a>
                                @endhasFeature
                            @endif

                            {{-- CSV Campaigns --}}
                            @if (checkPermission('tenant.bulk_campaigns.send'))
                                <a href="{{ tenant_route('tenant.csvcampaign') }}"
                                    class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                     {{ request()->routeIs('tenant.csvcampaign')
                                         ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                         : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                    <x-heroicon-o-clipboard-document
                                        class="mr-4 flex-shrink-0 h-6 w-6
                                         {{ request()->routeIs('tenant.csvcampaign')
                                             ? 'text-indigo-600 dark:text-slate-300'
                                             : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                        aria-hidden="true" />
                                    {{ t('bulk_campaign') }}
                                </a>
                            @endif

                            <!-- Message Bot -->
                            @if (checkPermission('tenant.message_bot.view'))
                                @hasFeature('message_bots')
                                    <a href="{{ tenant_route('tenant.messagebot.list') }}"
                                        class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                               {{ request()->routeIs('tenant.messagebot.list')
                                   ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                   : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                        <x-heroicon-o-chat-bubble-bottom-center-text
                                            class="mr-4 flex-shrink-0 h-6 w-6
                                   {{ request()->routeIs('tenant.messagebot.list')
                                       ? 'text-indigo-600 dark:text-slate-300'
                                       : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                            aria-hidden="true" />
                                        {{ t('message_bot') }}
                                    </a>
                                @endhasFeature
                            @endif

                            @if (checkPermission('tenant.template_bot.view'))
                                @hasFeature('template_bots')
                                    <!-- Template Bot -->
                                    <a href="{{ tenant_route('tenant.templatebot.list') }}"
                                        class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                           {{ request()->routeIs('tenant.templatebot.list')
                               ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                               : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                        <x-heroicon-o-tag
                                            class="mr-4 flex-shrink-0 h-6 w-6
                                   {{ request()->routeIs('tenant.templatebot.list')
                                       ? 'text-indigo-600 dark:text-slate-300'
                                       : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                            aria-hidden="true" />
                                        {{ t('template_bot') }}
                                    </a>
                                @endhasFeature
                            @endif

                            <p class="text-sm text-gray-500 dark:text-slate-400 font-medium px-5 py-4">
                                {{ t('support') }}
                            </p>

                            @if (checkPermission(['tenant.chat.view', 'tenant.chat.read_only']))
                                <!-- Chat -->
                                @hasFeature('conversations')
                                    <a href="{{ tenant_route('tenant.chat') }}"
                                        class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                {{ request()->routeIs('tenant.chat')
                                    ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                    : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                        <x-heroicon-o-chat-bubble-oval-left
                                            class="mr-4 flex-shrink-0 h-6 w-6
                                {{ request()->routeIs('tenant.chat')
                                    ? 'text-indigo-600 dark:text-slate-300'
                                    : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                            aria-hidden="true" />
                                        {{ t('chat') }}
                                    </a>
                                @endhasFeature
                            @endif


                            <!-- Support Tickets -->
                            @if (module_exists('Tickets') && module_enabled('Tickets'))
                                <a href="{{ tenant_route('tenant.tickets.index') }}"
                                    class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md {{ request()->routeIs('tenant.tickets.*')
                                        ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                        : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                    <x-heroicon-o-ticket
                                        class="mr-4 flex-shrink-0 h-6 w-6 {{ request()->routeIs('client.tickets.*')
                                            ? 'text-indigo-600 dark:text-slate-300'
                                            : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                        aria-hidden="true" />
                                    {{ t('support_tickets') }}
                                </a>
                            @endif

                            @if (checkPermission(['tenant.system_settings.view', 'tenant.whatsmark_settings.view']))
                                <p class="text-sm text-gray-500 dark:text-slate-400 font-meduim px-5 py-4">
                                    {{ t('settings') }}
                                </p>
                            @endif

                            <!-- WhatsMark Settings -->
                            @if (checkPermission('tenant.whatsmark_settings.view'))
                                <a href="{{ tenant_route('tenant.settings.whatsapp-auto-lead') }}"
                                    class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                {{ in_array(request()->route()->getName(), [
                                    'tenant.settings.whatsapp-auto-lead',
                                    'tenant.settings.stop-bot',
                                    'tenant.settings.web-hooks',
                                    'tenant.settings.support-agent',
                                    'tenant.settings.notification-sound',
                                    'tenant.settings.ai-integration',
                                    'tenant.settings.auto-clear-chat-history',
                                ])
                                    ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                    : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                    <x-heroicon-o-wrench-screwdriver
                                        class="mr-4 flex-shrink-0 h-6 w-6
                                    {{ in_array(request()->route()->getName(), [
                                        'tenant.settings.whatsapp-auto-lead',
                                        'tenant.settings.stop-bot',
                                        'tenant.settings.web-hooks',
                                        'tenant.settings.support-agent',
                                        'tenant.settings.notification-sound',
                                        'tenant.settings.ai-integration',
                                        'tenant.settings.auto-clear-chat-history',
                                    ])
                                        ? 'text-indigo-600 dark:text-slate-300'
                                        : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                        aria-hidden="true" />
                                    {{ t('whatsmark_settings') }}
                                </a>
                            @endif

                            <!-- system Settings -->
                            @if (checkPermission('tenant.system_settings.view'))
                                <a href="{{ tenant_route('tenant.settings.general') }}"
                                    class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                            {{ in_array(request()->route()->getName(), ['tenant.settings.general', 'tenant.settings.pusher'])
                                ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                    <x-heroicon-o-cog
                                        class="mr-4 flex-shrink-0 h-6 w-6
                                {{ in_array(request()->route()->getName(), ['tenant.settings.general', 'tenant.settings.pusher'])
                                    ? 'text-indigo-600 dark:text-slate-300'
                                    : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                        aria-hidden="true" />
                                    {{ t('system_settings') }}
                                </a>
                            @endif
                        @endif

                        <button x-on:click.prevent="mobileOpen = true"
                            class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white mt-2 w-full">
                            <x-heroicon-o-cog-6-tooth
                                class="mr-4 flex-shrink-0 h-6 w-6 text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300"
                                aria-hidden="true" />
                            {{ t('setup') }}
                        </button>
                    </nav>
                </div>
            </div>
            <div class="flex-shrink-0 w-14" aria-hidden="true">
                <!-- Dummy element to force sidebar to shrink to fit close icon -->
            </div>
        </div>
    </div>
    <!-- Static sidebar for desktop -->
    <div class="hidden lg:flex lg:fixed lg:inset-y-0 z-40 transition-[width] duration-300 ease-in-out bg-white dark:bg-slate-800 border-r border-slate-300 dark:border-slate-600 "
        x-data="{ isCollapsed: localStorage.getItem('sidebarCollapsed') === 'true', setupMenu: {{ request()->routeIs(
            'tenant.staff.list',
            'tenant.staff.save',
            'tenant.roles.list',
            'tenant.roles.save',
            'tenant.status',
            'tenant.source',
            'tenant.activity-log.list',
            'tenant.languages',
            'tenant.emails',
            'tenant.logs.index',
            'tenant.ai-prompt',
            'tenant.canned-reply',
        )
            ? 'true'
            : 'false' }} }" x-init="$watch('isCollapsed', value => {
            localStorage.setItem('sidebarCollapsed', value);
            // Dispatch custom event
            window.dispatchEvent(new CustomEvent('sidebar-state-changed', {
                detail: { collapsed: value }
            }));

        });" :class="isCollapsed ? 'lg:w-[75px]' : 'lg:w-[240px]'">
        <div class="flex-1 flex flex-col min-h-0 border-r border-slate-300 dark:border-r dark:border-slate-600 relative"
            :class="isCollapsed ? 'w-0' : 'lg:w-[240px]'">
            <!-- Close Button -->

            <div x-show="setupMenu" x-cloak class="hidden lg:flex lg:fixed lg:inset-y-0"
                x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 transform -translate-x-full"
                x-transition:enter-end="opacity-100 transform translate-x-0"
                x-transition:leave="transition ease-in duration-300"
                x-transition:leave-start="opacity-100 transform translate-x-0"
                x-transition:leave-end="opacity-0 transform -translate-x-full">
                <div
                    :class="(isCollapsed ? 'w-[75px]' : 'w-[15rem]') +
                    ' flex flex-col min-h-0 border-r border-slate-300 dark:border-slate-600 transition-all ease-in-out duration-300'">
                    <!-- Top bar with Close button -->
                    <div class="flex justify-between items-center py-4 flex-shrink-0 px-5 bg-white dark:bg-slate-800">
                        <span x-show="!isCollapsed" class="text-lg font-semibold text-gray-600 dark:text-slate-300">
                            {{ t('setup') }}
                        </span>
                        <!-- Close Button -->
                        <button :class="isCollapsed ? 'pl-[8px]' : 'pl-[0px]'" x-on:click="setupMenu = false"
                            class="text-gray-500 dark:text-slate-400">
                            <x-heroicon-o-x-mark class="w-5 h-5" />
                        </button>
                    </div>

                    <div class="flex-1 flex flex-col overflow-y-auto bg-white dark:bg-slate-800">

                        <nav class="flex-1 px-2">
                            <!-- Staff -->
                            @if (request()->routeIs('tenant.*'))
                                @if (checkPermission('tenant.staff.view'))
                                    @hasFeature('staff')
                                        <a href="{{ tenant_route('tenant.staff.list') }}"
                                            class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                                {{ request()->routeIs('tenant.staff.list')
                                                    ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                                    : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                            <x-heroicon-o-users data-tippy-content="{{ t('staff') }}"
                                                data-tippy-placement="right"
                                                class="mr-4 flex-shrink-0 h-6 w-6
                                                    {{ request()->routeIs('tenant.staff.list')
                                                        ? 'text-indigo-600 dark:text-slate-300'
                                                        : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                                aria-hidden="true" />
                                            <span x-show="!isCollapsed"> {{ t('staff') }}</span>
                                        </a>
                                    @endhasFeature
                                @endif
                                <!-- Role -->
                                @if (checkPermission('tenant.role.view') && Auth::user()->is_admin && Auth::user()->user_type === 'tenant')
                                    <a href="{{ tenant_route('tenant.roles.list') }}"
                                        class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                           {{ request()->routeIs('tenant.roles.list')
                                               ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                               : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                        <x-heroicon-o-swatch data-tippy-content="{{ t('role') }}"
                                            data-tippy-placement="right"
                                            class="mr-4 flex-shrink-0 h-6 w-6
                                               {{ request()->routeIs('tenant.roles.list')
                                                   ? 'text-indigo-600 dark:text-slate-300'
                                                   : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                            aria-hidden="true" />
                                        <span x-show="!isCollapsed">{{ t('role') }}</span>
                                    </a>
                                @endif

                                @if (checkPermission('tenant.status.view'))
                                    <a href="{{ tenant_route('tenant.status') }}"
                                        class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                           {{ request()->routeIs('tenant.status')
                                               ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                               : 'text-gray-600 hover:bg-indigo-50 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                        <x-heroicon-c-adjustments-horizontal data-tippy-content="{{ t('status') }}"
                                            data-tippy-placement="right"
                                            class="mr-4 flex-shrink-0 h-6 w-6
                                           {{ request()->routeIs('tenant.status')
                                               ? 'text-indigo-600 dark:text-slate-300'
                                               : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}" />
                                        <span x-show="!isCollapsed">{{ t('status') }}</span>
                                    </a>
                                @endif

                                @if (checkPermission('tenant.source.view'))
                                    <a href="{{ tenant_route('tenant.source') }}"
                                        class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                       {{ request()->routeIs('tenant.source')
                                           ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                           : 'text-gray-600 hover:bg-indigo-50 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                        <x-heroicon-o-square-3-stack-3d data-tippy-content="{{ t('source') }}"
                                            data-tippy-placement="right"
                                            class="mr-4 flex-shrink-0 h-6 w-6
                                       {{ request()->routeIs('tenant.source')
                                           ? 'text-indigo-600 dark:text-slate-300'
                                           : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}" />
                                        <span x-show="!isCollapsed">{{ t('source') }}</span>
                                    </a>
                                @endif

                                <!-- AI Prompts -->
                                @if (checkPermission('tenant.ai_prompt.view'))
                                    @hasFeature('ai_prompts')
                                        <a href="{{ tenant_route('tenant.ai-prompt') }}"
                                            class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                       {{ request()->routeIs('tenant.ai-prompt')
                                           ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                           : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                            <x-heroicon-o-rocket-launch data-tippy-content="{{ t('ai_prompts') }}"
                                                data-tippy-placement="right"
                                                class="mr-4 flex-shrink-0 h-6 w-6
                                       {{ request()->routeIs('tenant.ai-prompt')
                                           ? 'text-indigo-600 dark:text-slate-300'
                                           : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                                aria-hidden="true" />
                                            <span x-show="!isCollapsed">{{ t('ai_prompts') }}</span>
                                        </a>
                                    @endhasFeature
                                @endif

                                <!-- Canned Reply -->
                                @if (checkPermission('tenant.canned_reply.view'))
                                    @hasFeature('canned_replies')
                                        <a href="{{ tenant_route('tenant.canned-reply') }}"
                                            class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                       {{ request()->routeIs('tenant.canned-reply')
                                           ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                           : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                            <x-heroicon-m-arrow-right-on-rectangle
                                                data-tippy-content="{{ t('canned_reply') }}"
                                                data-tippy-placement="right"
                                                class="mr-4 flex-shrink-0 h-6 w-6
                                       {{ request()->routeIs('tenant.canned-reply')
                                           ? 'text-indigo-600 dark:text-slate-300'
                                           : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                                aria-hidden="true" />

                                            <span x-show="!isCollapsed">{{ t('canned_reply') }}</span>
                                        </a>
                                    @endhasFeature
                                @endif

                                <!-- Activity Log -->
                                @if (checkPermission('tenant.activity_log.view'))
                                    <a href="{{ tenant_route('tenant.activity-log.list') }}"
                                        class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                   {{ request()->routeIs('tenant.activity-log.list')
                                       ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                       : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                        <x-heroicon-s-arrow-path data-tippy-content="{{ t('activity_log') }}"
                                            data-tippy-placement="right"
                                            class="mr-4 flex-shrink-0 h-6 w-6
                                       {{ request()->routeIs('tenant.activity-log.list')
                                           ? 'text-indigo-600 dark:text-slate-300'
                                           : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                            aria-hidden="true" />
                                        <span x-show="!isCollapsed">{{ t('activity_log') }}</span>
                                    </a>
                                @endif


                                @if (Auth::user()->is_admin && Auth::user()->user_type === 'tenant')
                                    <!-- Language for desktop -->
                                    <a href="{{ tenant_route('tenant.languages') }}" @class([
                                        'group flex items-center px-4 py-2 text-sm font-medium rounded-r-md',
                                        request()->routeIs('tenant.languages')
                                            ? 'border-l-4 border-indigo-600 bg-indigo-50 dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                            : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white',
                                    ])>
                                        <x-heroicon-s-language data-tippy-content="{{ t('languages') }}"
                                            data-tippy-placement="right" @class([
                                                'mr-4 flex-shrink-0 h-6 w-6',
                                                request()->routeIs('tenant.languages')
                                                    ? 'text-indigo-600 dark:text-slate-300'
                                                    : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300',
                                            ])
                                            aria-hidden="true" />
                                        <span x-show="!isCollapsed">{{ t('languages') }}</span>
                                    </a>
                                @endif

                                <!-- Email Templates -->
                                @if (checkPermission('tenant.email_template.view'))
                                    <a href="{{ tenant_route('tenant.emails') }}" @class([
                                        'group flex items-center px-4 py-2 text-sm font-medium rounded-r-md',
                                        request()->routeIs('tenant.emails')
                                            ? 'border-l-4 border-indigo-600 bg-indigo-50 dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                            : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white',
                                    ])>
                                        <x-heroicon-o-envelope
                                            data-tippy-content="{{ t('email_template_list_title') }}"
                                            data-tippy-placement="right" @class([
                                                'mr-4 flex-shrink-0 h-6 w-6',
                                                request()->routeIs('tenant.emails')
                                                    ? 'text-indigo-600 dark:text-slate-300'
                                                    : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300',
                                            ])
                                            aria-hidden="true" />
                                        <span x-show="!isCollapsed">{{ t('email_template_list_title') }}</span>
                                    </a>
                                @endif

                                {{-- System Logs --}}

                                @if (module_exists('LogViewer') && module_enabled('LogViewer'))
                                    <a href="{{ tenant_route('tenant.logs.index') }}" @class([
                                        'group flex items-center px-4 py-2 text-sm font-medium rounded-r-md',
                                        request()->routeIs('tenant.logs.index')
                                            ? 'border-l-4 border-indigo-600 bg-indigo-50 dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                            : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white',
                                    ])>
                                        <x-heroicon-o-document-chart-bar data-tippy-content="{{ t('system_logs') }}"
                                            data-tippy-placement="right" @class([
                                                'mr-4 flex-shrink-0 h-6 w-6',
                                                request()->routeIs('tenant.logs.index')
                                                    ? 'text-indigo-600 dark:text-slate-300'
                                                    : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300',
                                            ])
                                            aria-hidden="true" />
                                        <span x-show="!isCollapsed">{{ t('system_logs') }}</span>
                                    </a>
                                @endif
                            @endif
                        </nav>
                    </div>
                </div>
            </div>

            <div class="flex justify-center transition-all duration-300 ease-in-out">
                <a href="#" class="flex items-center bg-white dark:bg-slate-800">
                    <img x-show="!isCollapsed"
                        x-bind:src="theme === 'light' || (theme === 'system' && window.matchMedia(
                                    '(prefers-color-scheme: light)')
                                .matches) ?
                            '{{ !empty($systemSettings['company_light_logo']) ? Storage::url($systemSettings['company_light_logo']) : url('./img/light_logo.png') }}' :
                            '{{ !empty($systemSettings['company_dark_logo']) ? Storage::url($systemSettings['company_dark_logo']) : url('./img/dark_logo.png') }}'"
                        alt="#" class="h-20 my-1 object-contain" x-cloak>

                    <img x-show="isCollapsed" x-cloak
                        x-bind:src="theme === 'light' || (theme === 'system' && window.matchMedia(
                                    '(prefers-color-scheme: light)')
                                .matches) ?
                            '{{ !empty($systemSettings['favicon']) ? Storage::url($systemSettings['favicon']) : url('./img/favicon-32x32.png') }}' :
                            '{{ !empty($systemSettings['favicon']) ? Storage::url($systemSettings['favicon']) : url('./img/favicon-32x32.png') }}'"
                        alt="Logo" class="h-12 object-contain">
                </a>
            </div>
            <div x-show="!setupMenu" class="absolute right-[-16px] top-4 transition-all duration-300 ease-in-out">
                <button @click="isCollapsed = !isCollapsed"
                    class="flex items-center justify-center w-8 h-8 rounded-full bg-white dark:bg-slate-700 shadow-md border border-gray-200 dark:border-slate-600 text-gray-600 dark:text-slate-300 hover:text-indigo-600 dark:hover:text-white focus:outline-none transition-all duration-300 ease-in-out hover:shadow-lg transform hover:scale-105">
                    <template x-if="!isCollapsed">
                        <x-heroicon-s-arrow-left class="w-4 h-4 transition-transform duration-300 ease-in-out" />
                    </template>
                    <template x-if="isCollapsed">
                        <x-heroicon-s-arrow-right class="w-4 h-4 transition-transform duration-300 ease-in-out" />
                    </template>
                </button>
            </div>
            <div class="flex-1 flex flex-col overflow-y-auto bg-white dark:bg-slate-800">
                <nav class="flex-1 py-4" :class="sidebarCollapsed ? 'px-1' : 'px-2'">
                    {{-- Sidebar for admin : Start --}}
                    @if (request()->routeIs('tenant.*'))
                        <a href="{{ tenant_route('tenant.dashboard') }}"
                            class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                        {{ request()->routeIs('tenant.dashboard')
                            ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                            : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                            <x-heroicon-o-squares-2x2
                                x-bind:data-tippy-content="isCollapsed ? '{{ t('dashboard') }}' : null"
                                x-bind:data-tippy-placement="isCollapsed ? 'right' : null"
                                class="mr-4 flex-shrink-0 h-6 w-6
                        {{ request()->routeIs('tenant.dashboard')
                            ? 'text-indigo-600 dark:text-slate-300'
                            : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                aria-hidden="true" />
                            <span x-show="!isCollapsed" x-transition:enter.duration.700ms class="whitespace-nowrap">
                                {{ t('dashboard') }}
                            </span>
                        </a>

                        @if (
                            (get_tenant_setting_from_db('whatsapp', 'is_whatsmark_connected') == 0 ||
                                get_tenant_setting_from_db('whatsapp', 'is_webhook_connected') == 0) &&
                                checkPermission('tenant.connect_account.connect'))
                            <a href="{{ tenant_route('tenant.connect') }}"
                                class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                        {{ request()->routeIs(['tenant.connect', 'tenant.waba'])
                            ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                            : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                <x-heroicon-o-link
                                    x-bind:data-tippy-content="isCollapsed ? '{{ t('connect_waba') }}' : null"
                                    x-bind:data-tippy-placement="isCollapsed ? 'right' : null"
                                    class="mr-4 flex-shrink-0 h-6 w-6
                        {{ request()->routeIs(['tenant.connect', 'tenant.waba'])
                            ? 'text-indigo-600 dark:text-slate-300'
                            : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                    aria-hidden="true" />
                                <span x-show="!isCollapsed" x-transition:enter.duration.700ms
                                    class="whitespace-nowrap">
                                    {{ t('connect_waba') }}
                                </span>
                            </a>
                        @elseif (get_tenant_setting_from_db('whatsapp', 'is_whatsmark_connected') == 1 &&
                                get_tenant_setting_from_db('whatsapp', 'is_webhook_connected') == 1 &&
                                checkPermission('tenant.connect_account.view'))
                            <a href="{{ tenant_route('tenant.waba') }}"
                                class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                {{ request()->routeIs(['tenant.waba', 'tenant.waba'])
                                    ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                    : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                <x-heroicon-o-link
                                    x-bind:data-tippy-content="isCollapsed ? '{{ t('connect_waba') }}' : null"
                                    x-bind:data-tippy-placement="isCollapsed ? 'right' : null"
                                    class="mr-4 flex-shrink-0 h-6 w-6
                                {{ request()->routeIs(['tenant.waba', 'tenant.waba'])
                                    ? 'text-indigo-600 dark:text-slate-300'
                                    : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                    aria-hidden="true" />
                                <span x-show="!isCollapsed" x-transition:enter.duration.700ms
                                    class="whitespace-nowrap">
                                    {{ t('connect_waba') }}
                                </span>
                            </a>
                        @endif

                        @if (checkPermission(['tenant.subscription.view', 'tenant.invoices.view']))
                            <div x-show="!isCollapsed" x-transition:enter.duration.700ms
                                class="text-sm text-gray-500 dark:text-slate-400 font-medium px-5 py-4">
                                {{ t('sales') }}
                            </div>
                        @endif
                        @if (checkPermission('tenant.subscription.view'))
                            <a href="{{ tenant_route('tenant.subscriptions') }}"
                                class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                        {{ request()->routeIs('tenant.subscriptions')
                            ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                            : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                <x-heroicon-o-credit-card
                                    x-bind:data-tippy-content="isCollapsed ? '{{ t('subscription') }}' : null"
                                    x-bind:data-tippy-placement="isCollapsed ? 'right' : null"
                                    class="mr-4 flex-shrink-0 h-6 w-6
                        {{ request()->routeIs('tenant.subscriptions')
                            ? 'text-indigo-600 dark:text-slate-300'
                            : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                    aria-hidden="true" />
                                <span x-show="!isCollapsed" x-transition:enter.duration.700ms
                                    class="whitespace-nowrap">
                                    {{ t('subscription') }}
                                </span>
                            </a>
                        @endif

                        @if (checkPermission('tenant.invoices.view'))
                            <a href="{{ tenant_route('tenant.invoices') }}"
                                class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                                {{ request()->routeIs('tenant.invoices')
                                                    ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                                    : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                <x-heroicon-o-receipt-percent
                                    x-bind:data-tippy-content="isCollapsed ? '{{ t('invoices') }}' : null"
                                    x-bind:data-tippy-placement="isCollapsed ? 'right' : null"
                                    class="mr-4 flex-shrink-0 h-6 w-6
                                                {{ request()->routeIs('tenant.invoices')
                                                    ? 'text-indigo-600 dark:text-slate-300'
                                                    : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                    aria-hidden="true" />
                                <span x-show="!isCollapsed" x-transition:enter.duration.700ms
                                    class="whitespace-nowrap">{{ t('invoices') }}</span>
                            </a>
                        @endif

                        @if (checkPermission(['tenant.contact.view', 'tenant.contact.view_own']))
                            @hasFeature('contacts')
                                <div x-show="!isCollapsed" x-transition:enter.duration.700ms
                                    class="text-sm text-gray-500 dark:text-slate-400 font-medium px-5 py-4">
                                    {{ t('contact') }}
                                </div>

                                <a href="{{ tenant_route('tenant.contacts.list') }}"
                                    class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                        {{ request()->routeIs('tenant.contacts.list')
                                            ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                            : 'text-gray-600 hover:bg-indigo-50 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                    <x-heroicon-o-user-circle
                                        x-bind:data-tippy-content="isCollapsed ? '{{ t('contact') }}' : null"
                                        x-bind:data-tippy-placement="isCollapsed ? 'right' : null"
                                        class="mr-4 flex-shrink-0 h-6 w-6
                                        {{ request()->routeIs('tenant.contacts.list')
                                            ? 'text-indigo-700 dark:text-slate-300'
                                            : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}" />
                                    <span x-show="!isCollapsed" x-transition:enter.duration.700ms
                                        class="whitespace-nowrap">
                                        {{ t('contact') }}
                                    </span>
                                </a>
                            @endhasFeature
                        @endif

                        @if (checkPermission('tenant.template.view'))
                            <div x-show="!isCollapsed" x-transition:enter.duration.700ms
                                class="text-sm text-gray-500 dark:text-slate-400 font-medium px-5 py-4">
                                {{ t('templates') }}
                            </div>
                            <a href="{{ tenant_route('tenant.template.list') }}"
                                class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                        {{ request()->routeIs('tenant.template.list')
                            ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                            : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                <x-heroicon-o-document
                                    x-bind:data-tippy-content="isCollapsed ? '{{ t('templates') }}' : null"
                                    x-bind:data-tippy-placement="isCollapsed ? 'right' : null"
                                    class="mr-4 flex-shrink-0 h-6 w-6
                            {{ request()->routeIs('tenant.template.list')
                                ? 'text-indigo-600 dark:text-slate-300'
                                : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}" />
                                <span x-show="!isCollapsed" x-transition:enter.duration.700ms
                                    class="whitespace-nowrap">
                                    {{ t('templates') }}
                                </span>
                            </a>
                        @endif

                        @if (checkPermission([
                                'tenant.campaigns.view',
                                'tenant.bulk_campaigns.send',
                                'tenant.message_bot.view',
                                'tenant.template_bot.view',
                            ]))
                            <div x-show="!isCollapsed" x-transition:enter.duration.700ms
                                class="text-sm text-gray-500 dark:text-slate-400 font-medium px-5 py-4">
                                {{ t('marketing') }}
                            </div>
                        @endif

                        {{-- Campaigns List --}}
                        @if (checkPermission('tenant.campaigns.view'))
                            @hasFeature('campaigns')
                                <a href="{{ tenant_route('tenant.campaigns.list') }}"
                                    class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                    {{ request()->routeIs('tenant.campaigns.list')
                                        ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                        : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                    <x-heroicon-o-megaphone
                                        x-bind:data-tippy-content="isCollapsed ? '{{ t('campaign') }}' : null"
                                        x-bind:data-tippy-placement="isCollapsed ? 'right' : null"
                                        class="mr-4 flex-shrink-0 h-6 w-6
                                        {{ request()->routeIs('tenant.campaigns.list')
                                            ? 'text-indigo-600 dark:text-slate-300'
                                            : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                        aria-hidden="true" />
                                    <span x-show="!isCollapsed" x-transition:enter.duration.700ms
                                        class="whitespace-nowrap">
                                        {{ t('campaign') }}
                                    </span>
                                </a>
                            @endhasFeature
                        @endif


                        {{-- CSV Campaigns --}}
                        @if (checkPermission('tenant.bulk_campaigns.send'))
                            <a href="{{ tenant_route('tenant.csvcampaign') }}"
                                class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                                 {{ request()->routeIs('tenant.csvcampaign')
                                     ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                     : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                <x-heroicon-o-clipboard-document
                                    x-bind:data-tippy-content="isCollapsed ? '{{ t('bulk_campaign') }}' : null"
                                    x-bind:data-tippy-placement="isCollapsed ? 'right' : null"
                                    class="mr-4 flex-shrink-0 h-6 w-6
                                     {{ request()->routeIs('tenant.csvcampaign')
                                         ? 'text-indigo-600 dark:text-slate-300'
                                         : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                    aria-hidden="true" />
                                <span x-show="!isCollapsed" x-transition:enter.duration.700ms
                                    class="whitespace-nowrap">
                                    {{ t('bulk_campaign') }}
                                </span>
                            </a>
                        @endif

                        <!-- Message Bot -->
                        @if (checkPermission('tenant.message_bot.view'))
                            @hasFeature('message_bots')
                                <a href="{{ tenant_route('tenant.messagebot.list') }}"
                                    class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                           {{ request()->routeIs('tenant.messagebot.list')
                               ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                               : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                    <x-heroicon-o-chat-bubble-bottom-center-text
                                        x-bind:data-tippy-content="isCollapsed ? '{{ t('message_bot') }}' : null"
                                        x-bind:data-tippy-placement="isCollapsed ? 'right' : null"
                                        class="mr-4 flex-shrink-0 h-6 w-6
                               {{ request()->routeIs('tenant.messagebot.list')
                                   ? 'text-indigo-600 dark:text-slate-300'
                                   : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                        aria-hidden="true" />
                                    <span x-show="!isCollapsed" x-transition:enter.duration.700ms
                                        class="whitespace-nowrap">
                                        {{ t('message_bot') }}
                                    </span>
                                </a>
                            @endhasFeature
                        @endif

                        @if (checkPermission('tenant.template_bot.view'))
                            @hasFeature('template_bots')
                                <!-- Template Bot -->
                                <a href="{{ tenant_route('tenant.templatebot.list') }}"
                                    class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                       {{ request()->routeIs('tenant.templatebot.list')
                           ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                           : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                    <x-heroicon-o-tag
                                        x-bind:data-tippy-content="isCollapsed ? '{{ t('template_bot') }}' : null"
                                        x-bind:data-tippy-placement="isCollapsed ? 'right' : null"
                                        class="mr-4 flex-shrink-0 h-6 w-6
                               {{ request()->routeIs('tenant.templatebot.list')
                                   ? 'text-indigo-600 dark:text-slate-300'
                                   : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                        aria-hidden="true" />
                                    <span x-show="!isCollapsed" x-transition:enter.duration.700ms
                                        class="whitespace-nowrap">
                                        {{ t('template_bot') }}
                                    </span>
                                </a>
                            @endhasFeature
                        @endif

                        <div x-show="!isCollapsed" x-transition:enter.duration.700ms
                            class="text-sm text-gray-500 dark:text-slate-400 font-medium px-5 py-4">
                            {{ t('support') }}
                        </div>

                        <!-- Chat -->
                        @if (checkPermission(['tenant.chat.view', 'tenant.chat.read_only']))

                            @hasFeature('conversations')
                                <a href="{{ tenant_route('tenant.chat') }}"
                                    class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                            {{ request()->routeIs('tenant.chat')
                                ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                    <x-heroicon-o-chat-bubble-oval-left
                                        x-bind:data-tippy-content="isCollapsed ? '{{ t('chat') }}' : null"
                                        x-bind:data-tippy-placement="isCollapsed ? 'right' : null"
                                        class="mr-4 flex-shrink-0 h-6 w-6
                            {{ request()->routeIs('tenant.chat')
                                ? 'text-indigo-600 dark:text-slate-300'
                                : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                        aria-hidden="true" />
                                    <span x-show="!isCollapsed" x-transition:enter.duration.700ms
                                        class="whitespace-nowrap">
                                        {{ t('chat') }}
                                    </span>
                                </a>
                            @endhasFeature
                        @endif

                        <!-- Support Tickets -->
                        @if (module_exists('Tickets') && module_enabled('Tickets'))
                            <a href="{{ tenant_route('tenant.tickets.index') }}"
                                class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md {{ request()->routeIs('tenant.tickets.*')
                                    ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                    : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                <x-heroicon-o-ticket
                                    x-bind:data-tippy-content="isCollapsed ? '{{ t('support_tickets') }}' : null"
                                    x-bind:data-tippy-placement="isCollapsed ? 'right' : null"
                                    class="mr-4 flex-shrink-0 h-6 w-6 {{ request()->routeIs('client.tickets.*')
                                        ? 'text-indigo-600 dark:text-slate-300'
                                        : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                    aria-hidden="true" />
                                <span x-show="!isCollapsed" x-transition:enter.duration.700ms
                                    class="whitespace-nowrap">
                                    {{ t('support_tickets') }}
                                </span>
                            </a>
                        @endif

                        @if (checkPermission(['tenant.system_settings.view', 'tenant.whatsmark_settings.view']))
                            <div x-show="!isCollapsed" x-transition:enter.duration.700ms
                                class="text-sm text-gray-500 dark:text-slate-400 font-medium px-5 py-4">
                                {{ t('settings') }}
                            </div>
                        @endif

                        <!-- WhatsMark Settings -->
                        @if (checkPermission('tenant.whatsmark_settings.view'))
                            <a href="{{ tenant_route('tenant.settings.whatsapp-auto-lead') }}"
                                class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                            {{ in_array(request()->route()->getName(), [
                                'tenant.settings.whatsapp-auto-lead',
                                'tenant.settings.stop-bot',
                                'tenant.settings.web-hooks',
                                'tenant.settings.support-agent',
                                'tenant.settings.notification-sound',
                                'tenant.settings.ai-integration',
                                'tenant.settings.auto-clear-chat-history',
                            ])
                                ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                                : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                <x-heroicon-o-wrench-screwdriver
                                    x-bind:data-tippy-content="isCollapsed ? '{{ t('whatsmark_settings') }}' : null"
                                    x-bind:data-tippy-placement="isCollapsed ? 'right' : null"
                                    class="mr-4 flex-shrink-0 h-6 w-6
                                {{ in_array(request()->route()->getName(), [
                                    'tenant.settings.whatsapp-auto-lead',
                                    'tenant.settings.stop-bot',
                                    'tenant.settings.web-hooks',
                                    'tenant.settings.support-agent',
                                    'tenant.settings.notification-sound',
                                    'tenant.settings.ai-integration',
                                    'tenant.settings.auto-clear-chat-history',
                                ])
                                    ? 'text-indigo-600 dark:text-slate-300'
                                    : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                    aria-hidden="true" />
                                <span x-show="!isCollapsed" x-transition:enter.duration.700ms
                                    class="whitespace-nowrap">
                                    {{ t('whatsmark_settings') }}
                                </span>
                            </a>
                        @endif

                        <!-- system Settings -->
                        @if (checkPermission('tenant.system_settings.view'))
                            <a href="{{ tenant_route('tenant.settings.general') }}"
                                class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md
                        {{ in_array(request()->route()->getName(), [
                            'tenant.settings.general',
                            'tenant.settings.email',
                            'tenant.settings.pusher',
                        ])
                            ? 'border-l-4 border-indigo-600 bg-indigo-50  dark:border-indigo-600 text-indigo-700 dark:bg-slate-900 dark:text-white'
                            : 'text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white' }}">
                                <x-heroicon-o-cog
                                    x-bind:data-tippy-content="isCollapsed ? '{{ t('system_settings') }}' : null"
                                    x-bind:data-tippy-placement="isCollapsed ? 'right' : null"
                                    class="mr-4 flex-shrink-0 h-6 w-6
                            {{ in_array(request()->route()->getName(), [
                                'tenant.settings.general',
                                'tenant.settings.email',
                                'tenant.settings.pusher',
                            ])
                                ? 'text-indigo-600 dark:text-slate-300'
                                : 'text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300' }}"
                                    aria-hidden="true" />
                                <span x-show="!isCollapsed" x-transition:enter.duration.700ms
                                    class="whitespace-nowrap">
                                    {{ t('system_settings') }}
                                </span>
                            </a>
                        @endif
                    @endif

                    <button x-on:click.prevent="setupMenu = true"
                        class="group flex items-center px-4 py-2 text-sm font-medium rounded-r-md text-gray-600 hover:bg-indigo-100 hover:text-indigo-800 dark:text-slate-300 dark:hover:bg-slate-700 dark:hover:text-white mt-2 w-full">
                        <x-heroicon-o-cog-6-tooth
                            x-bind:data-tippy-content="isCollapsed ? '{{ t('setup') }}' : null"
                            x-bind:data-tippy-placement="isCollapsed ? 'right' : null"
                            class="mr-4 flex-shrink-0 h-6 w-6 text-gray-500 group-hover:text-indigo-700 dark:text-slate-400 group-hover:dark:text-slate-300"
                            aria-hidden="true" />
                        <span x-show="!isCollapsed" x-transition:enter.duration.700ms class="whitespace-nowrap">
                            {{ t('setup') }}
                        </span>
                    </button>
                </nav>
            </div>
        </div>
    </div>
    {{-- SIDEBAR FOR TENANT --}}
</div>
