<?php

namespace App\Http\Controllers;

use App\Helpers\EmailTemplateHelper;
use Corbital\LaravelEmails\Facades\Email;
use Illuminate\Http\Request;

class TestEmailController extends Controller
{
    /**
     * Test SMTP connection using the Laravel Emails package
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function testSmtpWithPackage(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
        ]);

        try {
            // Check if we have a test template, or create one if needed
            $testTemplate = EmailTemplateHelper::ensureTestTemplateExists();

            if (is_smtp_valid()) {
                // Send test email using the package
                Email::to($request->email)
                    ->subject('SMTP Test from Laravel Emails Package')
                    ->template($testTemplate->slug, [
                        'app_name' => config('app.name'),
                        'app_url' => config('app.url'),
                        'recipient_email' => $request->email,
                    ])
                    ->send();
            }

            return response()->json([
                'success' => true,
                'message' => t('email_send_successfully'),
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => t('failed_send_test_email').$e->getMessage(),
            ]);
        }
    }

    // Methods moved to EmailTemplateHelper class
}
