@props(['status'])

@php
$classes = match ($status) {
    'open' => 'bg-blue-100 text-blue-700 dark:bg-blue-900/50 dark:text-blue-300 border border-blue-200 dark:border-blue-800',
    'answered' => 'bg-green-100 text-green-700 dark:bg-green-900/50 dark:text-green-300 border border-green-200 dark:border-green-800',
    'on_hold' => 'bg-yellow-100 text-yellow-700 dark:bg-yellow-900/50 dark:text-yellow-300 border border-yellow-200 dark:border-yellow-800',
    'closed' => 'bg-gray-100 text-gray-700 dark:bg-gray-900/50 dark:text-gray-300 border border-gray-200 dark:border-gray-800',
    default => 'bg-gray-100 text-gray-700 dark:bg-gray-900/50 dark:text-gray-300 border border-gray-200 dark:border-gray-800',
};
@endphp

<span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $classes }}">
    {{ t($status) }}
</span>
